/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import com.aetherteam.aether.item.AetherItems;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1381;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class AechorPlant
extends class_1314
implements class_1603 {
    private static final class_2940<Integer> DATA_SIZE_ID = class_2945.method_12791(AechorPlant.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_POISON_REMAINING_ID = class_2945.method_12791(AechorPlant.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_TARGETING_ENTITY_ID = class_2945.method_12791(AechorPlant.class, (class_2941)class_2943.field_13323);
    private float sinage;
    private float sinageAdd;

    public AechorPlant(class_1299<? extends AechorPlant> type, class_1937 level) {
        super(type, level);
        this.field_6194 = 5;
        this.setPoisonRemaining(2);
        if (level.method_8608()) {
            this.sinage = this.method_59922().method_43057() * 6.0f;
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1381((class_1603)this, 1.0, 60, 10.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_SIZE_ID, (Object)0);
        builder.method_56912(DATA_POISON_REMAINING_ID, (Object)0);
        builder.method_56912(DATA_TARGETING_ENTITY_ID, (Object)false);
    }

    public void method_5674(class_2940<?> dataAccessor) {
        if (DATA_SIZE_ID.equals(dataAccessor)) {
            this.method_18382();
        }
        super.method_5674(dataAccessor);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.setSize(this.method_59922().method_43048(4) + 1);
        this.method_33574(class_243.method_24955((class_2382)this.method_24515()));
        return spawnData;
    }

    public static boolean checkAechorPlantSpawnRules(class_1299<? extends AechorPlant> aechorPlant, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON) && level.method_22335(pos, 0) > 8 && level.method_8407() != class_1267.field_5801 && (reason != class_3730.field_16459 || random.method_43048(10) == 0 && !AechorPlant.inRadiusOfFlowers(level, pos, 10) && !AechorPlant.inRadiusOfEnchantedFlowers(level, pos, 40));
    }

    public static boolean inRadiusOfFlowers(class_1936 level, class_2338 pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    if (xOffset * xOffset + zOffset * zOffset > radius * radius || !level.method_8320(pos.method_10069(xOffset, yOffset, zOffset)).method_26164(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_DETERRENT)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean inRadiusOfEnchantedFlowers(class_1936 level, class_2338 pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    if (xOffset * xOffset + zOffset * zOffset > radius * radius || !level.method_8320(pos.method_10069(xOffset, yOffset, zOffset)).method_26164(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_DETERRENT) || !level.method_8320(pos.method_10069(xOffset, yOffset, zOffset).method_10074()).method_26164(AetherTags.Blocks.ENCHANTED_GRASS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON) && !this.method_5765()) {
            this.method_5768();
        }
        if (!this.method_37908().method_8608()) {
            if (this.method_5968() != null) {
                this.setTargetingEntity(true);
            } else if (this.method_5968() == null && this.getTargetingEntity()) {
                this.setTargetingEntity(false);
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().method_8608()) {
            this.sinage += this.sinageAdd;
            this.sinageAdd = this.field_6235 > 0 ? 0.45f : (this.getTargetingEntity() ? 0.3f : 0.15f);
            if (this.sinage >= (float)Math.PI * 2) {
                this.sinage -= (float)Math.PI * 2;
            }
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574((class_1792)AetherItems.SKYROOT_BUCKET.get()) && this.getPoisonRemaining() > 0) {
            this.setPoisonRemaining(this.getPoisonRemaining() - 1);
            class_1799 itemStack1 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)((class_1792)AetherItems.SKYROOT_POISON_BUCKET.get()).method_7854());
            player.method_6122(hand, itemStack1);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    public void method_5762(double x, double y, double z) {
    }

    public void method_6043() {
    }

    public boolean method_5931() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.field_6235 == 0) {
            for (int i = 0; i < 8; ++i) {
                double d1 = this.method_23317() + (double)(this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.5;
                double d2 = this.method_23318() + 0.25 + (double)(this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.5;
                double d3 = this.method_23321() + (double)(this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.5;
                double d4 = (double)(this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.5;
                double d5 = (double)(this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.5;
                this.method_37908().method_8406((class_2394)class_2398.field_11214, d1, d2, d3, d4, 0.25, d5);
            }
        }
        return super.method_5643(source, amount);
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        PoisonNeedle needle = new PoisonNeedle(this.method_37908(), (class_1309)this);
        double x = target.method_23317() - this.method_23317();
        double z = target.method_23321() - this.method_23321();
        double sqrt = Math.sqrt(x * x + z * z + 0.1);
        double y = 0.1 + sqrt * 0.5 + (this.method_23318() - target.method_23318()) * 0.25;
        double distance = 1.5 / sqrt;
        needle.method_7485(x *= distance, y + 0.5, z *= distance, 0.285f + (float)y * 0.08f, 1.0f);
        this.method_5783(AetherSoundEvents.ENTITY_AECHOR_PLANT_SHOOT.get(), 2.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)needle);
    }

    public int getSize() {
        return (Integer)this.method_5841().method_12789(DATA_SIZE_ID);
    }

    public void setSize(int size) {
        this.method_5841().method_12778(DATA_SIZE_ID, (Object)size);
    }

    public int getPoisonRemaining() {
        return (Integer)this.method_5841().method_12789(DATA_POISON_REMAINING_ID);
    }

    public void setPoisonRemaining(int poisonRemaining) {
        this.method_5841().method_12778(DATA_POISON_REMAINING_ID, (Object)poisonRemaining);
    }

    public boolean getTargetingEntity() {
        return (Boolean)this.method_5841().method_12789(DATA_TARGETING_ENTITY_ID);
    }

    public void setTargetingEntity(boolean targetingEntity) {
        this.method_5841().method_12778(DATA_TARGETING_ENTITY_ID, (Object)targetingEntity);
    }

    public float getSinage() {
        return this.sinage;
    }

    public float getSinageAdd() {
        return this.sinageAdd;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return AetherSoundEvents.ENTITY_AECHOR_PLANT_HURT.get();
    }

    protected class_3414 method_6002() {
        return AetherSoundEvents.ENTITY_AECHOR_PLANT_DEATH.get();
    }

    public boolean method_6057(class_1297 entity) {
        return (double)this.method_5739(entity) <= 8.0 && super.method_6057(entity);
    }

    public class_4048 method_55694(class_4050 pose) {
        float width = 0.75f + (float)this.getSize() * 0.125f;
        float height = 0.5f + (float)this.getSize() * 0.075f;
        return class_4048.method_18385((float)width, (float)height).method_55685(height / 1.15f);
    }

    protected boolean method_23734() {
        return true;
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_5579().comp_349() != AetherEffects.INEBRIATION.get() && super.method_6049(effect);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Size", this.getSize());
        tag.method_10569("Poison Remaining", this.getPoisonRemaining());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Size")) {
            this.setSize(tag.method_10550("Size"));
        }
        if (tag.method_10545("Poison Remaining")) {
            this.setPoisonRemaining(tag.method_10550("Poison Remaining"));
        }
    }
}

